//****************************************************************************
//
// (c) COPYRIGHT SOFTWARE SOURCE  1991 - 1996
//     ALL RIGHTS RESERVED
//
// program - vbis4032.h
// purpose - VMX Library definitions.
// author  - Tony Altwies
// history - 1-18-96
//
//  REMEMBER: For VmxGet and VmxPut, the Data is found in the place pointed to
//            by "lpTypeDef". You must allocate this space or get it from VB.
//            It must correspond to a VB structure form, which has a 4-byte
//            Structure Member Alignment. The following rule is used to
//            extract data and put data into this structure.
//
//            Data elements are placed (packed) into the structure at the
//            current Position if they fit at the current position within
//            the current 4-byte alignment slot. Otherwise, the current
//            position in incremented to the next 4-byte alignment slot.
//
//                          MEMBER ALIGNMENTS
//                          -----------------
//                  Short           is      2 bytes
//                  Long            is      4 bytes
//                  etc.
//                   .
//                   .
//  Variable len String     is      4 bytes (BSTR pointer) {These are OLE BSTRS}
//  Fixed len    String     is      its size.
//                                  for purposes of alignment test, use an alignment
//                                  size of 1.  In other words, fixed length strings
//                                  always fit in the structure and will pack up
//                                  against one another.    Be sure to calculate
//                                  where the correct current pointer is within
//                                  the next alignment slot.
//          Example:
//                                  short(S),long(L),str*5(c),short,long(L),
//                                  var Str(P)
//
//                          SS--      "-" represents alignment pad.
//                          LLLL
//                          CCCC
//                          CSS-
//                          PPPP
//
//  Note: for arrays of elements, the first element is aligned and then
//           the array elements are packed.
//
//          Also use the SysStringByte versions of string handling functions,
//          i.e. SysStringByteLen(BSTR). See VB4DLL.TXT in the SDK.
//
//
//****************************************************************************

# define XLOOKUP                      1
# define XNEXT                        2
# define XPREVIOUS                    4
# define XCURRENT                     8

# define XANY                         16
# define XEQ                          32
# define XBEGINS                      64

# define XNOT                         128
# define XLT                          256
# define XGT                          512
# define XLE                          1024
# define XGE                          2048

// flags for VmxGet

# define XGET_DATA                    4096
# define XNO_DATA                     8192
# define XNATIVE                      16384

// flags for VmxPut

# define XADD_ONLY                    1
# define XREPLACE_ONLY                2
# define XADD_OR_REPLACE              4

// function prototypes

short FAR PASCAL VmxCreate(BSTR   *Filespec,
                           LPSHORT lpMaxKeyWidth,
                           LPLONG  lpGroupSize,
                           LPSHORT lpInitAlloc,
                           LPSHORT lpCrOpts,
                           BSTR   *Format);

short FAR PASCAL VmxKill(BSTR *Filespec);

short FAR PASCAL VmxOpen(BSTR    *Filespec,
                         LPSHORT  lpLocatorSize,
                         LPSHORT  lpOmode,
                         LPHANDLE lphwmcb,
                         BSTR    *Password);

short FAR PASCAL VmxClose(LPHANDLE lpDatasetNumber);

short FAR PASCAL VmxGet(LPHANDLE lpDatasetNumber, LPSHORT lpSecIndex,
                        LPSHORT lpOption, BSTR *SrchKey,
                        BSTR  *SecKey, BSTR  *PriKey, LPSTR lpTypeDef);

short FAR PASCAL VmxPut(LPHANDLE lpDatasetNumber, BSTR  *Key,
                        LPSTR lpTypeDef, LPSHORT lpprotmode);

short FAR PASCAL VmxDelete(LPHANDLE lpDatasetNumber, BSTR  *Key);

short FAR PASCAL VmxBOF(LPHANDLE lpDatasetNumber, LPSHORT lpSecIndex);
short FAR PASCAL VmxEOF(LPHANDLE lpDatasetNumber, LPSHORT lpSecIndex);

short FAR PASCAL VmxMovePtr(LPHANDLE lpDatasetNumber, LPSHORT lpSecIndex,
                            LPLONG lpRelativeCount, LPSHORT lpOption );

short FAR PASCAL VmxCancel(LPHANDLE lpDatasetNumber);

short FAR PASCAL VmxWriteNote(LPHANDLE lpDatasetNumber, BSTR  *Pname,
                              BSTR  *Pstring);

short FAR PASCAL VmxReadNote(LPHANDLE lpDatasetNumber, BSTR  *Pname,
                             BSTR  *Pstring);

short FAR PASCAL VmxFlush(LPHANDLE lpDatasetNumber);
short FAR PASCAL VmxInfo(LPHANDLE lpDatasetNumber, LPVSTATS lpvstats);
BSTR  FAR PASCAL VmxReturnCode(LPSHORT lperrno);

short FAR PASCAL VmxEncode(LPSTR lpTypeDef, BSTR  *Dict, BSTR  *Record);
short FAR PASCAL VmxDecode(BSTR  *Record, BSTR  *Dict, LPSTR lpTypeDef);

short FAR PASCAL VmxLock(LPHANDLE lpDatasetNumber, BSTR  *Key);
short FAR PASCAL VmxUnlock(LPHANDLE lpDatasetNumber, BSTR  *Key);

short FAR PASCAL VmxFetchField(
                           LPHANDLE lpDatasetNumber,
                           BSTR         *Dict,
                           BSTR         *Record,
                           LPSHORT       lpFldNo,
                           BSTR         *FldType,
                           LPSTR         lpFieldData);

short FAR PASCAL VmxStoreField(
                           LPHANDLE lpDatasetNumber,
                           BSTR         *Dict,
                           BSTR         *Record,
                           LPSHORT       lpFldNo,
                           BSTR         *FldType,
                           LPSTR         lpFieldData);

short FAR PASCAL VmxFix(BSTR *Filespec, LPSHORT Foptions);
short FAR PASCAL VmxVal(BSTR *Filespec, BSTR *Ebuf, LPSHORT Foptions);

//****************************************************************************
